# 系统监控告警实践

> 及时发现问题，保障系统稳定



大家好，我是程序员鱼皮，今天分享一些很实用的系统监控告警工具。

无论你是用 Vibe Coding 做个人项目，还是想做一款真正的产品，掌握系统监控告警的方法都能帮你及时发现和处理问题，保障系统稳定运行。



## 为什么要用监控告警？

说到监控告警，没有企业开发经验的同学非常容易忽视它，甚至会有同学觉得没有必要，大不了出了 Bug 再修就是了。

![](https://pic.yupi.icu/1/image-20240729172241587.png)

**这种想法大错特错！**

我们把系统想象成人的身体。有的时候，一个人表面看起来可能很健康，但可能只是没有机会发现自己体内的异常，结果等到真的出事了，往往要承担的后果更严重。所以才需要定期体检，及时发现和处理问题。系统监控告警的作用也是类似的，能够及时发现系统中潜在的异常和问题、线上出了问题也能第一时间发现，尽早处理，从而预防或减轻故障。

此外，监控系统还有一些其他的好处，我们接着往下看。



## 怎么实现监控告警呢？

最直接能想到的办法就是自己写代码实现，比如给要重点关注的功能加点儿逻辑，出现某个异常的时候发送一条短信 / 邮件 / 企微消息即可。我们最开始就是这么做的：

![](https://pic.yupi.icu/1/image-20240729173020018.png)

但其实业务告警只是监控告警的其中一个层面，就像是人体的表面皮肤检查。如果我们想更全面地、更准确地监控系统的健康，还要里里外外做个全方位的体检，包括服务器监控、网络监控、应用监控、数据库监控、API 接口监控等等。

是的，听上去就很复杂，所以监控在现代运维中有了一个更专业的别名，叫 “可观测性”。可观测性是指系统能够通过监控和分析其内部状态来了解和诊断其健康状况和性能的能力。这个概念不仅包含了传统的监控，还扩展到了数据的收集、分析和响应。举个例子，我们通过监控发现系统的内存利用率不高，就可以适当降配节约成本；发现系统的内存利用率过高，就可以考虑是否要升配扩容。

想要自己优化系统的可观测性还是很复杂的，数据收集、数据存储、数据分析、告警机制、可用性保障、性能等等都要考虑，大厂都是有规模的基础设施团队来做。

对于我们个人开发者或者小公司来说，既然是全方位的 “体检”，我们一般不会自己来做，而是会选择更专业的工具或服务，直接使用和接入就好。下面就推荐几个我们团队在用的。



## 监控工具推荐

### 1、服务器监控

1）服务器自带的监控能力

只要你使用的是大厂的云服务器，基本都自带了服务器监控，还可以设置告警。比如下图腾讯云轻量应用服务器的监控，能看到 CPU、内存、网络带宽、硬盘等资源的使用情况：

![](https://pic.yupi.icu/1/image-20240729175223676.png)



2）容器平台的监控能力

如果你使用的是容器的方式来部署项目，基本上容器平台也自带了监控告警能力。比如微信云托管的服务监控，除了看到系统资源的占用情况外，还能看到接口调用量、请求错误量、接口 QPS 和响应时间，相当于自带了一部分 API 接口监控能力。

![](https://pic.yupi.icu/1/image-20240729175504698.png)

而且云托管平台支持在微信群内接收告警信息，非常方便。一旦节点被攻击了，立刻就能通知到你。

![](https://pic.yupi.icu/1/image-20240729175751550.png)



### 2、数据库监控

以前，没有数据库监控，我们很难关注到数据库的运行状态，不知道它工作辛不辛苦、有没有摸鱼或者超负荷加班。但现在，如果你使用的是第三方云服务商的云数据库，可以直接在平台上查看数据库的资源利用情况。比如我们用的腾讯云数据库自带的监控：

![](https://pic.yupi.icu/1/image-20240729180105756.png)

以前只能通过用户反馈或者服务器的故障来发现危害系统的慢 SQL，现在使用云数据库自带的智能管家，就能第一时间帮你发现慢 SQL，防患于未然。

![](https://pic.yupi.icu/1/image-20240729180157868.png)

还能一键帮你的数据库做个体检，不是 100 分的话都要及时修改：

![](https://pic.yupi.icu/1/image-20240729180528480.png)



### 3、应用监控

应用监控的范围比较广，我们使用的是阿里云的应用实时监控服务 ARMS，主要的原因是对比下来阿里在 Java 应用服务这一块的专业性确实更高。

包括应用服务器（比如 Java 的 Tomcat）的状态、API 接口调用情况、系统内部依赖服务的调用情况、定时任务的调用情况、线程池的状态、虚拟机的内存、GC 的情况等等。

![](https://pic.yupi.icu/1/image-20240729181837634.png)

![](https://pic.yupi.icu/1/image-20240729182031915.png)

还能查看应用拓扑结构、分析调用链路等等：

![](https://pic.yupi.icu/1/image-20240729181939087.png)

除了监控能力外，它的告警能力是真的强！我们把服务接入到了企微，只要有个环节出了问题，立刻就会给我们发送告警。还可以快速查看告警详情、认领告警、屏蔽告警等等。

![](https://pic.yupi.icu/1/image-20240729182157448.png)

实不相瞒，我们刚接入这玩意的那几天，还是挺痛苦的，因为暴露了很多之前没发现的系统问题，大半夜的企微也一直滴滴滴滴滴滴搁那响！我们团队的开发同学苦不堪言。

![](https://pic.yupi.icu/1/image-20240729182459731.png)

不过现在已经习惯了。。。额，准确地说是系统经过优化后，已经变得更健康了~ 

不管怎么样，接入监控告警还是很有必要的，感觉像是开了通透世界，对系统的状态了若指掌了！

但是监控服务的使用超过一定次数，是需要费用的，大概每月几十 G 的免费额度吧，企业项目的话其实很快就用完了。用于学习或者个人网站可以试试。



### 4、前端监控

除了上面的监控外，有时我们还想了解用户的行为、用户属性和业务指标，比如每天有多少用户访问网站、是用的 PC 还是手机、手机是什么牌子的、有多少新用户注册等等。那么可能还需要前端监控（当然也可以后端埋点统计），之前分享过的，用百度统计，一行代码就能接入到前端网站中，很方便~

![](https://pic.yupi.icu/1/image-20240625112621549.png)






## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
